/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.Platform;
import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkHandlerEnvironment;
import info.u_team.u_team_core.impl.common.CommonNetworkHandler;
import info.u_team.u_team_core.util.EnvironmentUtil;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1255;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class FabricNetworkHandler
extends CommonNetworkHandler {
    FabricNetworkHandler(class_2960 channel, int protocolVersion) {
        super(channel, protocolVersion);
    }

    @Override
    public void register() {
        for (CommonNetworkHandler.MessagePacketPayload messagePayload : this.messages.values()) {
            NetworkHandlerEnvironment environment = messagePayload.payload().handlerEnvironment();
            if (environment.isValid(NetworkEnvironment.CLIENT)) {
                PayloadTypeRegistry.playS2C().register(messagePayload.type(), messagePayload.streamCodec());
                EnvironmentUtil.runWhen(Platform.Environment.CLIENT, () -> () -> Client.registerReceiver(messagePayload));
            }
            if (!environment.isValid(NetworkEnvironment.SERVER)) continue;
            PayloadTypeRegistry.playC2S().register(messagePayload.type(), messagePayload.streamCodec());
            ServerPlayNetworking.registerGlobalReceiver(messagePayload.type(), (payload, context) -> {
                messagePayload.handle(payload, (NetworkContext)new FabricNetworkContext(messagePayload, NetworkEnvironment.SERVER, (class_1657)context.player(), (class_1255<?>)context.player().field_13995));
                context.player().method_5682();
            });
        }
    }

    private static class FabricNetworkContext<M>
    extends CommonNetworkHandler.CommonNetworkContext<M> {
        private final NetworkEnvironment environment;
        private final class_1657 player;
        private final class_1255<?> executor;

        private FabricNetworkContext(CommonNetworkHandler.MessagePacketPayload<M> messagePayload, NetworkEnvironment environment, class_1657 player, class_1255<?> executor) {
            super(messagePayload);
            this.environment = environment;
            this.player = player;
            this.executor = executor;
        }

        @Override
        public NetworkEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public class_1657 getPlayer() {
            return this.player;
        }

        @Override
        public CompletableFuture<Void> execute(Runnable runnable) {
            if (!this.executor.method_18854()) {
                return this.executor.method_5382(runnable);
            }
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
    }

    private static class Client {
        private Client() {
        }

        private static void registerReceiver(CommonNetworkHandler.MessagePacketPayload<?> messagePayload) {
            ClientPlayNetworking.registerGlobalReceiver(messagePayload.type(), (payload, context) -> {
                messagePayload.handle(payload, (NetworkContext)new FabricNetworkContext(messagePayload, NetworkEnvironment.CLIENT, (class_1657)context.player(), (class_1255<?>)context.client()));
                context.player().method_5682();
            });
        }
    }

    public static class Factory
    implements NetworkHandler.Factory {
        @Override
        public NetworkHandler create(class_2960 location, int protocolVersion) {
            return new FabricNetworkHandler(location, protocolVersion);
        }
    }
}

